/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util.io;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWatcher
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(FileWatcher.class);
    private final Path file;
    private final Path dir;
    private final Path parentDir;
    private final WatchService watcher;
    private WatchKey fileKey;
    private WatchKey dirKey;

    public FileWatcher(Path file) throws IOException {
        this.file = file;
        this.dir = Files.isSymbolicLink(file) ? file.toRealPath(new LinkOption[0]).getParent() : file.getParent();
        this.parentDir = Preconditions.checkNotNull(this.dir.getParent(), "Cannot monitor file in filesystem root");
        this.watcher = FileSystems.getDefault().newWatchService();
    }

    private WatchKey registerKey(Path dir, WatchEvent.Kind<?> ... events) throws InterruptedException {
        WatchKey key = null;
        boolean failed = false;
        do {
            try {
                key = dir.register(this.watcher, events);
            }
            catch (Exception e) {
                if (!failed) {
                    log.info("Cannot register watch for {}", (Object)this.file, (Object)e);
                }
                failed = true;
                Thread.sleep(1000L);
            }
        } while (key == null);
        if (failed) {
            log.info("Registered watch key for {}", (Object)dir);
        } else {
            log.debug("Registered watch key for {}", (Object)dir);
        }
        return key;
    }

    private boolean keysValid() {
        return this.fileKey != null && this.fileKey.isValid() && this.dirKey != null && this.dirKey.isValid();
    }

    private void cancelKeys() {
        if (this.dirKey != null) {
            this.dirKey.cancel();
        }
        if (this.fileKey != null) {
            this.fileKey.cancel();
        }
        log.debug("Cancelled all watch keys");
    }

    public boolean waitForChange() throws InterruptedException {
        boolean haveResult = false;
        boolean filePresent = true;
        block0: do {
            boolean first;
            boolean bl = first = this.fileKey == null;
            while (!this.keysValid()) {
                this.dirKey = this.registerKey(this.parentDir, StandardWatchEventKinds.ENTRY_DELETE);
                this.fileKey = this.registerKey(this.dir, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                if (first) continue;
                filePresent = Files.exists(this.file, new LinkOption[0]);
                break block0;
            }
            WatchKey key = this.watcher.take();
            for (WatchEvent<?> event : key.pollEvents()) {
                if (event.kind() == StandardWatchEventKinds.OVERFLOW) {
                    log.info("Too many events to handle while watching changes on {}", (Object)this.file);
                    this.cancelKeys();
                    continue block0;
                }
                Path evPath = (Path)event.context();
                log.debug("Got event {} on {}", (Object)event.kind(), (Object)evPath);
                if (key.equals(this.dirKey)) {
                    if (!this.dir.endsWith(evPath)) continue;
                    this.cancelKeys();
                    continue block0;
                }
                if (!key.equals(this.fileKey) || !this.file.endsWith(evPath)) continue;
                haveResult = true;
                filePresent = event.kind() == StandardWatchEventKinds.ENTRY_CREATE || event.kind() == StandardWatchEventKinds.ENTRY_MODIFY;
            }
            log.debug("---");
            key.reset();
        } while (!haveResult);
        return filePresent;
    }

    @Override
    public void close() throws IOException {
        this.watcher.close();
    }
}

